<?php
    header('Access-Control-Allow-Origin: *'); 
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    
    include "vendor/autoload.php";
    use Stenfrank\UBL21dian\XAdES\SignInvoice;
    use Stenfrank\UBL21dian\XAdES\SignApplicationResponse;

    $json = json_decode($_POST['data'],true);

    // if (str_contains($json['ROOT'], "ERP2")) {
    //     $root = str_replace('/Apache24/','/',$json['ROOT']);
    // } else {
    //     if (!str_contains($json['ROOT'], "Apache24")) {
    //         $root = $json['ROOT'] + 'Apache24/';
    //     }
    // }

    if (strpos($json['ROOT'], "ERP2") !== false) {
        $root = str_replace('/Apache24/','/',$json['ROOT']);
    } else {
        if (strpos($json['ROOT'], "Apache24") === false) {
            $root = $json['ROOT'].'Apache24/';
        }
    }

    $xml = file_get_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/'.$json['ARCHIVO'].'.xml');

    // $certificado = str_replace('\\\\','/',$json['FIRMADIGIT']);
    $certificado = $json['FIRMADIGIT'];
    $password = $json['SERIECERTI'];
    $clavetecica = $json['J_CLAVETEC'];
    $tipodocumento = $json['invoicetype'];

    $documento = new DOMDocument();
    $documento->loadXML($xml);

    if(substr($json['ARCHIVO'],0,4)=='acus'){
        $sign = new SignApplicationResponse($certificado,$password,$documento);
        file_put_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/XMLRADIAN/acuse_recibido_prueba.xml',$sign->xml);
        file_put_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/acuse_recibido_prueba.xml',$sign->xml);
        file_put_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/acuse_recibido_prueba.txt',$sign->xml);  
    } else {
        $sign = new SignInvoice($certificado,$password,$documento,$clavetecica,$tipodocumento);
        file_put_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/XML/'.$json['ARCHIVO'].'.xml',$sign->xml);
        file_put_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/'.$json['ARCHIVO'].'.xml',$sign->xml);
        file_put_contents($root.'DATA/'.substr($json['codigoempresa'],0,5).'/TEMPORALES/'.$json['ARCHIVO'].'.txt',$sign->xml);
    }

    echo json_encode($sign->resdcufe);
?>