<?php
    header('Access-Control-Allow-Origin: *'); 
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

    date_default_timezone_set("America/Bogota");
    
    $json = json_decode($_POST['data'],true);
    
    
    $titulo = $json['titulo'];
    $idfactura = $json['prefijo'].$json['FOLIO'];
    $fechaingreso = $json['fechacontrato'];
    $fecharetiro = $json['fecharetiro'];
    $fechaliquidacioninicio = $json['FECHALIQUIDACIONINICIO'];
    $fechaliquidacionfin = $json['FECHALIQUIDACIONFIN'];
    $tiempolaborado = $json['TIEMPOLABORADO'];
    $fechagen = $json['FECHAGEN'];
    $codigotrabajador = $json['identificacion'];
    $prefijo = $json['prefijo'];
    $consecutivo = $json['FOLIO'];
    $numero = $prefijo.$consecutivo;

    // LUGAR GENERACION XML
    $pais = "CO";
    $departaempresa = $json['DEPARTAEMP'];
    $municipioempresa = $json['CODMUNIEMP'];
    $idioma = "es";

    // PROVEEDOR XML
    
    $idsoftware = $json['IDSOFTWARE'];
    $pinsoftware = $json['PINDIAN'];
    $softwaresc = hash('sha384', $idsoftware.$pinsoftware.$numero);
    
    $hoy = getdate();
    $horafac = str_pad($hoy['hours'],2,'0',STR_PAD_LEFT).':'.str_pad($hoy['minutes'],2,'0',STR_PAD_LEFT).':'.str_pad($hoy['seconds'],2,'0',STR_PAD_LEFT).'-05:00';

    $vencimientofac = $json['vencimiento'];
    $fechahoy = $hoy['year'].'-'.str_pad($hoy['mon'],2,'0',STR_PAD_LEFT).'-'.str_pad($hoy['mday'],2,'0',STR_PAD_LEFT);
    $moneda = $json['moneda'];
    $totalitems = $json['NumeroItems'];

    $diasmesactual = date( 't', strtotime($fechahoy));
    $fechadeinicio = $hoy['year'].'-'.str_pad($hoy['mon'],2,'0',STR_PAD_LEFT).'-01';
    $fechafinal = $hoy['year'].'-'.str_pad($hoy['mon'],2,'0',STR_PAD_LEFT).'-'.$diasmesactual;

    $actividad = $json['ACTIVIDAD'];
    $razon = $json['RAZON'];
    $codmuniemp = $json['CODMUNIEMP'];
    $municiemp = $json['MUNICIEMP'];
    $departaemp = $json['DEPARTAEMP'];
    $coddepartaemp = substr($json['CODMUNIEMP'],0,2);
    $diremp = $json['DIREMP'];
    $nitsdemp = $json['NITSDEMP'];
    $dvemp = $json['DVEMP'];
    $tipdocemp = $json['TIPDOCEMP'];
    $resfiscalemp = $json['E_OFICINA'];
    $telemp = $json['TELEMP'];
    $emailemp = $json['EMAILEMP'];

    //datos de factura

    $cabecera = <<<XML
    <?xml version="1.0" encoding="utf-8" standalone="no"?>
    <NominaIndividual 
        xmlns="dian:gov:co:facturaelectronica:NominaIndividual"
        xmlns:xs="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
        xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2"
        xmlns:xades="http://uri.etsi.org/01903/v1.3.2#"
        xmlns:xades141="http://uri.etsi.org/01903/v1.4.1#"
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        SchemaLocation=""
        xsi:schemaLocation="dian:gov:co:facturaelectronica:NominaIndividual NominaIndividualElectronicaXSD.xsd">

        <ext:UBLExtension>
            <ext:UBLExtensions>
                <ext:ExtensionContent>
                </ext:ExtensionContent>
            </ext:UBLExtension>
        </ext:UBLExtensions>
        
        <Novedad CUNENov="">false</Novedad>
        <Periodo FechaIngreso=$fechaingreso 
            FechaRetiro=$fecharetiro 
            FechaLiquidacionInicio=$fechaliquidacioninicio
            FechaLiquidacionFin=$fechaliquidacionfin
            TiempoLaborado=$tiempolaborado
            FechaGen=$fechagen/>
        <NumeroSecuenciaXML CodigoTrabajador=$codigotrabajador
            Prefijo=$prefijo
            Consecutivo=$consecutivo
            Numero=$numero/>
        <LugarGeneracionXML Pais=$pais
            DepartamentoEstado=$departaempresa
            MunicipioCiudad=$municipioempresa
            Idioma=$idioma/>
        <ProveedorXML RazonSocial="Visualsoft Colombia SAS" NIT="901034990" DV="1" SoftwareID=$idsoftware SoftwareSC=$softwaresc />
        <CodigoQR></CodigoQR>
        <InformacionGeneral Version="V1.0: Documento Soporte de Pago de Nómina Electrónica" Ambiente="2" TipoXML="103" CUNE="fdbd039962804f7476ec9507df2952e4b83617aa243144f1ce7ba58d63db48f9fd40ef224147ed8e77a3c14e41475fce" EncripCUNE="CUNE-SHA384" FechaGen="2022-01-11" HoraGen="09:46:20-05:00" PeriodoNomina="5" TipoMoneda="COP" TRM="1.00" />
        <Notas>A</Notas>
        <Empleador RazonSocial="A"
                PrimerApellido="A"
                SegundoApellido="A"
                PrimerNombre="A"
                OtrosNombres="A"
                NIT="0"
                DV="0"
                Pais="A"
                DepartamentoEstado="0"
                MunicipioCiudad="0"
                Direccion="A"/>
        <Trabajador TipoTrabajador="0"
                    SubTipoTrabajador="0"
                    AltoRiesgoPension="false"
                    TipoDocumento="0"
                    NumeroDocumento="0"
                    PrimerApellido="A"
                    SegundoApellido="A"
                    PrimerNombre="A"
                    OtrosNombres="A"
                    LugarTrabajoPais="0"
                    LugarTrabajoDepartamentoEstado="0"
                    LugarTrabajoMunicipioCiudad="0"
                    LugarTrabajoDireccion="A"
                    SalarioIntegral="false"
                    TipoContrato="0"
                    Sueldo="0"
                    CodigoTrabajador="0"/>
        <Pago Forma="0"
            Metodo="0"
            Banco="A"
            TipoCuenta="A"
            NumeroCuenta="A"/>
        <FechasPagos>
            <FechaPago>9999-12-31</FechaPago>
        </FechasPagos>
        <Devengados>
            <Basico DiasTrabajados="0"
                    SueldoTrabajado="0.0"/>
            <Transporte AuxilioTransporte="0.0"
                        ViaticoManutAlojS="0.0"
                        ViaticoManutAlojNS="0.0"/>
            <HEDs>
                <HED HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HEDs>
            <HENs>
                <HEN HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HENs>
            <HRNs>
                <HRN HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HRNs>
            <HEDDFs>
                <HEDDF HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HEDDFs>
            <HRDDFs>
                <HRDDF HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HRDDFs>
            <HENDFs>
                <HENDF HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HENDFs>
            <HRNDFs>
                <HRNDF HoraInicio="9999-12-31T00:00:00"
                    HoraFin="9999-12-31T00:00:00"
                    Cantidad="0"
                    Porcentaje="0.00"
                    Pago="0.00"/>
            </HRNDFs>
            <Vacaciones>
                <VacacionesComunes FechaInicio="9999-12-31"
                                FechaFin="9999-12-31"
                                Cantidad="0"
                                Pago="0.00"/>
                <VacacionesCompensadas Cantidad="0"
                                    Pago="0.00"/>
            </Vacaciones>
            <Primas Cantidad="0"
                    Pago="0.00"
                    PagoNS="0.00"/>
            <Cesantias Pago="0"
                    Porcentaje="0.00"
                    PagoIntereses="0.00"/>
            <Incapacidades>
                <Incapacidad FechaInicio="9999-12-31"
                            FechaFin="9999-12-31"
                            Cantidad="0"
                            Tipo="0"
                            Pago="0.00"/>
            </Incapacidades>
            <Licencias>
                <LicenciaMP FechaInicio="9999-12-31"
                            FechaFin="9999-12-31"
                            Cantidad="0"
                            Pago="0.00"/>
                <LicenciaR FechaInicio="9999-12-31"
                        FechaFin="9999-12-31"
                        Cantidad="0"
                        Pago="0.00"/>
                <LicenciaNR FechaInicio="9999-12-31"
                            FechaFin="9999-12-31"
                            Cantidad="0"/>
            </Licencias>
            <Bonificaciones>
                <Bonificacion BonificacionS="0.00"
                            BonificacionNS="0.00"/>
            </Bonificaciones>
            <Auxilios>
                <Auxilio AuxilioS="0.00"
                        AuxilioNS="0.00"/>
            </Auxilios>
            <HuelgasLegales>
                <HuelgaLegal FechaInicio="9999-12-31"
                            FechaFin="9999-12-31"
                            Cantidad="0"/>
            </HuelgasLegales>
            <OtrosConceptos>
                <OtroConcepto DescripcionConcepto="A"
                            ConceptoS="0.00"
                            ConceptoNS="0.00"/>
            </OtrosConceptos>
            <Compensaciones>
                <Compensacion CompensacionO="0.00"
                            CompensacionE="0.00"/>
            </Compensaciones>
            <BonoEPCTVs>
                <BonoEPCTV PagoS="0.00"
                        PagoNS="0.00"
                        PagoAlimentacionS="0.00"
                        PagoAlimentacionNS="0.00"/>
            </BonoEPCTVs>
            <Comisiones>
                <Comision>0.00</Comision>
            </Comisiones>
            <PagosTerceros>
                <PagoTercero>0.00</PagoTercero>
            </PagosTerceros>
            <Anticipos>
                <Anticipo>0.00</Anticipo>
            </Anticipos>
            <Dotacion>0.00</Dotacion>
            <ApoyoSost>0.00</ApoyoSost>
            <Teletrabajo>0.00</Teletrabajo>
            <BonifRetiro>0.00</BonifRetiro>
            <Indemnizacion>0.00</Indemnizacion>
            <Reintegro>0.00</Reintegro>
        </Devengados>
        <Deducciones>
            <Salud Porcentaje="0.00"
                Deduccion="0.00"/>
            <FondoPension Porcentaje="0.00"
                        Deduccion="0.00"/>
            <FondoSP Porcentaje="0.00"
                    Deduccion="0.00"
                    PorcentajeSub="0.00"
                    DeduccionSub="0.00"/>
            <Sindicatos>
                <Sindicato Porcentaje="0.00"
                        Deduccion="0.00"/>
            </Sindicatos>
            <Sanciones>
                <Sancion SancionPublic="0.00"
                        SancionPriv="0.00"/>
            </Sanciones>
            <Libranzas>
                <Libranza Descripcion=""
                        Deduccion="0.00"/>
            </Libranzas>
            <PagosTerceros>
                <PagoTercero>0.00</PagoTercero>
            </PagosTerceros>
            <Anticipos>
                <Anticipo>0.00</Anticipo>
            </Anticipos>
            <OtrasDeducciones>
                <OtraDeduccion>0.00</OtraDeduccion>
            </OtrasDeducciones>
            <PensionVoluntaria>0.00</PensionVoluntaria>
            <RetencionFuente>0.00</RetencionFuente>
            <AFC>0.00</AFC>
            <Cooperativa>0.00</Cooperativa>
            <EmbargoFiscal>0.00</EmbargoFiscal>
            <PlanComplementarios>0.00</PlanComplementarios>
            <Educacion>0.00</Educacion>
            <Reintegro>0.00</Reintegro>
            <Deuda>0.00</Deuda>
        </Deducciones>
        <Redondeo>0.00</Redondeo>
        <DevengadosTotal>0.00</DevengadosTotal>
        <DeduccionesTotal>0.00</DeduccionesTotal>
        <ComprobanteTotal>0.00</ComprobanteTotal>
    </NominaIndividual>
    XML;
    $detalle = '';
    for($i=0;$i<count($json['detalle']);$i++){
        $codigo = $json['detalle'][$i]['codigo'];
        $descripcion = $json['detalle'][$i]['descripcion'];
        $cantidad = $json['detalle'][$i]['cantidad'];
        $precio = $json['detalle'][$i]['precio'];
        $parcial = $json['detalle'][$i]['parcial'];
        $iva = $json['detalle'][$i]['iva'];
        $valoriva = $json['detalle'][$i]['valiva'];
        $idnum = $i + 1;
        $detalle = $detalle.<<<XML

            <cac:InvoiceLine>
                <cbc:ID>$idnum</cbc:ID>
                <cbc:Note>$codigo</cbc:Note>
                <cbc:Note>nota</cbc:Note>
                <cbc:InvoicedQuantity unitCode="EA">$cantidad</cbc:InvoicedQuantity>
                <cbc:LineExtensionAmount currencyID="COP">$parcial</cbc:LineExtensionAmount>
                <cbc:FreeOfChargeIndicator>false</cbc:FreeOfChargeIndicator>
        XML;

        if($valoriva>0){
            $detalle = $detalle.<<<XML

                    <cac:TaxTotal>
                        <cbc:TaxAmount currencyID="COP">$valoriva</cbc:TaxAmount>
                        <cbc:TaxEvidenceIndicator>false</cbc:TaxEvidenceIndicator>
                        <cac:TaxSubtotal>
                            <cbc:TaxableAmount currencyID="COP">$parcial</cbc:TaxableAmount>
                            <cbc:TaxAmount currencyID="COP">$valoriva</cbc:TaxAmount>
                            <cac:TaxCategory>
                                <cbc:Percent>$iva</cbc:Percent>
                                <cac:TaxScheme>
                                    <cbc:ID>01</cbc:ID>
                                    <cbc:Name>IVA</cbc:Name>
                                </cac:TaxScheme>
                            </cac:TaxCategory>
                        </cac:TaxSubtotal>
                    </cac:TaxTotal>
            XML;
        }

        $detalle = $detalle.<<<XML
                
                <cac:Item>
                    <cbc:Description>$descripcion</cbc:Description>
                    <cac:SellersItemIdentification>
                        <cbc:ID>$codigo</cbc:ID>
                    </cac:SellersItemIdentification>
                    <cac:StandardItemIdentification>
                        <cbc:ID schemeID="999" schemeName="Estándar de adopción del contribuyente">$codigo</cbc:ID>
                    </cac:StandardItemIdentification>
                </cac:Item>
                <cac:Price>
                    <cbc:PriceAmount currencyID="COP">$precio</cbc:PriceAmount>
                    <cbc:BaseQuantity unitCode="EA">$cantidad</cbc:BaseQuantity>
                </cac:Price>
            </cac:InvoiceLine>
        XML;
    }

    $finalxml = $cabecera.$detalle;
    $finalxml = $finalxml.<<<XML

    </Invoice>
    XML;

    file_put_contents($json['ROOT'].'ERP/Apache24/DATANOMINA/'.$json['codigoempresa'].'/TEMPORALES/face_'.$json['tipodoc'].$json['NITSDEMP'].'_'.strtolower($json['prefijo']).'_'.str_pad($json['folio'],9,'0',STR_PAD_LEFT).'.xml',$finalxml);

    echo json_encode('XML Creado');
?>